#target premierepro-8.0
// Copyright 2014.  Adobe Systems, Incorporated.  All rights reserved.


/*
@@@START_XML@@@
<?xml version="1.0" encoding="UTF-8"?>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="en_US">
     <dc:title>Adobe Premiere Pro CC 2014</dc:title>
     <dc:description>This script enables other applications to communicate with Adobe Premiere Pro CC 2014.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="fr_FR">
     <dc:title>Adobe Premiere Pro CC 2014</dc:title>
     <dc:description>Ce script permet à d'autres applications de communiquer avec Adobe Premiere Pro CC 2014.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="ja_JP">
     <dc:title>Adobe Premiere Pro CC 2014</dc:title>
     <dc:description>このスクリプトは、他のアプリケーションと Adobe Premiere Pro CC 2014 との通信を有効にします。</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="de_DE">
     <dc:title>Adobe Premiere Pro CC 2014</dc:title>
     <dc:description>Mithilfe dieses Skripts können andere Anwendungen mit Adobe Premiere Pro CC 2014 kommunizieren.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="it_IT">
     <dc:title>Adobe Premiere Pro CC 2014</dc:title>
     <dc:description>Questo script consente ad altre applicazioni di comunicare con Adobe Premiere Pro CC 2014</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="es_ES">
     <dc:title>Adobe Premiere Pro CC 2014</dc:title>
     <dc:description>Este script posibilita que otras aplicaciones se comuniquen con Adobe Premiere Pro CC 2014</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="nl_NL">
     <dc:title>Adobe Premiere Pro CC 2014</dc:title>
     <dc:description>Dit script laat andere toepassingen toe te communiceren met Adobe Premiere Pro CC 2014</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="pt_BR">
     <dc:title>Adobe Premiere Pro CC 2014</dc:title>
     <dc:description>Este script permite que outros aplicativos se comuniquem com o Adobe Premiere Pro CC 2014</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="nb_NO">
     <dc:title>Adobe Premiere Pro CC 2014</dc:title>
     <dc:description>Skriptet gjør at andre programmer kan kommunisere med Adobe Premiere Pro CC 2014</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="da_DK">
     <dc:title>Adobe Premiere Pro CC 2014</dc:title>
     <dc:description>Dette script betyder, at andre programmer kan kommunikere med Adobe Premiere Pro CC 2014</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="fi_FI">
     <dc:title>Adobe Premiere Pro CC 2014</dc:title>
     <dc:description>Tämän komentosarjan avulla muut sovellukset ja Adobe Premiere Pro CC 2014 voivat kommunikoida keskenään</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="sv_SE">
     <dc:title>Adobe Premiere Pro CC 2014</dc:title>
     <dc:description>Det här skriptet gör det möjligt för andra program att kommunicera med Adobe Premiere Pro CC 2014</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="zh_TW">
     <dc:title>Adobe Premiere Pro CC 2014</dc:title>
     <dc:description>"此指令碼能讓其他應用程式與 Adobe Premiere Pro CC 2014 進行通訊。</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="zh_CN">
     <dc:title>Adobe Premiere Pro CC 2014</dc:title>
     <dc:description>"此脚本使其它应用程序能够与 Adobe Premiere Pro CC 2014 进行通信</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="ko_KR">
     <dc:title>Adobe Premiere Pro CC 2014</dc:title>
     <dc:description>"이 스크립트를 사용하면 다른 응용 프로그램에서 Adobe Premiere Pro CC 2014과(와) 통신할 수 있습니다.</dc:description>
</ScriptInfo>
@@@END_XML@@@
*/



premierepro8 = {};

premierepro8.premiereProTargetName = "premierepro-8.0";
premierepro8.premiereProAppName = "premierepro";
premierepro8.premiereProVersion = "8.1";
premierepro8.BridgeTargetName = "bridge";

/**
**	open
**
**	Open the passed in files. This may be one or many files.
**
*/
premierepro8.open = function(target)
{
	if (BridgeTalk.appSpecifier == premierepro8.premiereProTargetName)
	{
		var filePaths = [];

		for (var index = 0; index < target.length; index++)
		{
			filePaths[index] = target[index].fsName;
		}

		if (target.length == 1 && app.isDocument(filePaths))
		{
			app.openDocument(filePaths);
		}
		else if (app.isDocumentOpen())
		{
			document.importFiles(filePaths);
		}
	}
	else
	{
		var filesString = premierepro8.fileArrayToString(target);
		premierepro8.executeScript("premierepro8.open(" + filesString + ");");
	}
}

/**
**	executeScript
**
**	Execute the passed in script by sending a bridgetalk message.
*/
premierepro8.executeScript = function(script)
{
	if (BridgeTalk.appSpecifier == premierepro8.premiereProTargetName)
	{
		eval(script);
	}
	else
	{
		// Bring Premiere to the foreground.
		BridgeTalk.bringToFront(premierepro8.premiereProAppName);

		var btMessage = new BridgeTalk;
		btMessage.target = premierepro8.premiereProTargetName;
		btMessage.body = script;
		btMessage.send();
	}
}

/**
**	quit
**
**	Performs the equivalent of File>Exit.
*/
premierepro8.quit = function()
{
	if (BridgeTalk.appSpecifier == premierepro8.premiereProTargetName)
	{
		app.quit();
	}
	else
	{
		premierepro8.executeScript("app.quit();");
	}
}

/**
**	fileArrayToString
**
**	This routine create a string for the files array that we can transmit
**	over BridgeTalk as text, like this:
**
**	Array (File ('path1'), File ('path2'), File ('path3'))
*/
premierepro8.fileArrayToString = function(files)
{
	var filesString = new String("Array (");

	for (var index = 0; index < files.length; index++)
	{
		if (index > 0)
		{
			filesString += ", ";
		}

		filesString += "File ('" + files[index].absoluteURI.toString() + "')";
	}

	// close the Array
	filesString += ")";

	return filesString;
}

/**
**	Open Event
**
**	The event is:
**		event.type - document
**		event.location - document
**		event.object.constructor.name - Document
**		app.document.owner - premierepro-8.0
**
**	The app.document.owner is used to indicate that Bridge is in "slave" mode.
**	Used by applications that use Bridge for their own file browser.
**	Indicated in the window's title as "Opening in Adobe Premiere Pro CC 2014".
**
**	To get the selection use event.object.selections.
**
*/
premierepro8.eventHandler = function(event)
{
	var retval = {};
	retval.handled = false;

	if (event.type == "open"
		&& event.location == "document"
		&& event.object.constructor.name == "Document"
		&& app.document.owner == premierepro8.premiereProTargetName)
	{
		var sels = event.object.selections;
		var files = [];

		for (var i = 0; i < sels.length; i++)
		{
			files[i] = sels[i].spec;
		}

		if (files.length > 0)
		{
			premierepro8.open(files);
			retval.handled = true;
		}
	}

	return retval;
}

if (BridgeTalk.appName == premierepro8.BridgeTargetName)
{
	app.eventHandlers.push( {handler:premierepro8.eventHandler} );
}
